@extends('layouts.app')
@section('title') Servers @endsection
@section('content')

<div x-data="{ open: false, open_install: false, type: '' }">
 <div x-cloak
  x-show="open_install"
  @keydown.window.escape="open_install = false"
  class="relative z-10"
 >

  <div
   x-transition:enter="ease-out duration-300"
   x-transition:enter-start="opacity-0"
   x-transition:enter-end="opacity-100"
   x-transition:leave="ease-in duration-200"
   x-transition:leave-start="opacity-100"
   x-transition:leave-end="opacity-0"
   class="fixed inset-0 bg-gray-500 bg-opacity-75 transition-opacity"
   aria-hidden="true">
    <div class="fixed inset-0 z-10 w-screen overflow-y-auto">
     <div class="flex min-h-full items-end justify-center p-4 text-center items-center sm:p-0">
      <div class="bg-white dark:bg-slate-800 px-4 pb-4 pt-2 rounded-lg">
       <div
        x-transition:enter="ease-out duration-300"
        x-transition:enter-start="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
        x-transition:enter-end="opacity-100 translate-y-0 sm:scale-100"
        x-transition:leave="ease-in duration-200"
        x-transition:leave-start="opacity-100 translate-y-0 sm:scale-100"
        x-transition:leave-end="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
        x-description="Modal panel, show/hide based on modal state."
        class="relative transform overflow-hidden text-left transition-all my-8 w-full lg:max-w-3xl max-w-lg"
        @click.away="open_install = false">
         <div class="sm:flex sm:flex-col sm:items-start gap-2">
          <div class="text-2xl">Install ZoneCloud <span x-text="type"></span></div>
          <div class="mt-4 w-full">
           <div class="text-gray-900 dark:text-white gap-2">

            <div>Copy and paste this command in your server's terminal to install <span class="font-bold">ZoneCloud <span x-text="type"></span></span> and prepare the configuration file.</div>
            <div class="bg-white dark:bg-gray-900 mx-auto my-4 p-2 rounded-lg border border-gray-300 dark:border-gray-700">
             <pre id="auto_conf"
              class="overflow-x-auto text-xs text-gray-800 dark:text-gray-200 font-mono p-5"></pre>
            </div>
           </div>
          </div>
         </div>
        </div>
      </div>
     </div>
    </div>

   </div>
 </div>

 <div x-cloak
  @keydown.window.escape="open = false"
  x-show="open"
  class="relative z-10"
  aria-labelledby="modal-title"
  x-ref="dialog"
  aria-modal="true">

   <div x-show="open"
    x-transition:enter="ease-out duration-300"
    x-transition:enter-start="opacity-0"
    x-transition:enter-end="opacity-100"
    x-transition:leave="ease-in duration-200"
    x-transition:leave-start="opacity-100"
    x-transition:leave-end="opacity-0"
    x-description="Background backdrop, show/hide based on modal state."
    class="fixed inset-0 bg-gray-500 bg-opacity-75 transition-opacity"
    aria-hidden="true"></div>


   <div class="fixed inset-0 z-10 w-screen overflow-y-auto">
    <div class="flex min-h-full items-end justify-center p-4 text-center items-center sm:p-0">
     <div x-show="open"
      x-transition:enter="ease-out duration-300"
      x-transition:enter-start="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
      x-transition:enter-end="opacity-100 translate-y-0 sm:scale-100"
      x-transition:leave="ease-in duration-200"
      x-transition:leave-start="opacity-100 translate-y-0 sm:scale-100"
      x-transition:leave-end="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
      x-description="Modal panel, show/hide based on modal state."
      class="relative transform overflow-hidden rounded-lg bg-white dark:bg-slate-800 text-left shadow-xl transition-all my-8 w-full lg:max-w-3xl max-w-lg"
      @click.away="open = false">
       <div class="px-4 pb-4 pt-5 sm:p-6 sm:pb-4">
        <div class="sm:flex sm:flex-col sm:items-start gap-2">
         <div class="sm:flex sm:flex-row items-center">
          <div class="mx-auto flex h-12 w-12 flex-shrink-0 items-center justify-center rounded-full bg-gray-100 sm:mx-0 sm:h-10 sm:w-10">
           <svg xmlns="http://www.w3.org/2000/svg"
            fill="none"
            viewBox="0 0 24 24"
            stroke-width="1.5"
            stroke="currentColor"
            class="size-6">
             <path stroke-linecap="round"
              stroke-linejoin="round"
              d="M3.75 6.75h16.5M3.75 12H12m-8.25 5.25h16.5" />
            </svg>
          </div>
          <div class="mt-3 text-center sm:ml-4 sm:mt-0 sm:text-left">
           <h3 class="text-base font-semibold leading-6 text-gray-900 dark:text-white"
            id="modal-title">Configuration</h3>
          </div>
         </div>
         <div class="text-center w-full">
          <input type="hidden"
           id="conf_type">
          <div class="inline-flex rounded-md shadow-sm"
           id="config_modal">
            <button data-conf_id="zcloud_conf"
             class="btn_conf inline-flex items-center px-2 py-2 text-sm font-medium text-gray-900 bg-white border border-gray-200 rounded-s-lg hover:bg-gray-100 dark:bg-gray-800 dark:border-gray-700 dark:text-white dark:hover:text-white dark:hover:bg-gray-700">
              zCloud Config
             </button>
             <button data-conf_id="named_conf"
              class="btn_conf inline-flex items-center px-2 py-2 text-sm font-medium text-gray-900 bg-white border-t border-b border-gray-200 hover:bg-gray-100 dark:bg-gray-800 dark:border-gray-700 dark:text-white dark:hover:text-white dark:hover:bg-gray-700">
               named Config
              </button>
              <button data-conf_id="pdns_conf"
               class="btn_conf inline-flex items-center px-2 py-2 text-sm font-medium text-gray-900 bg-white rounded-e-lg border border-gray-200 hover:bg-gray-100 dark:bg-gray-800 dark:border-gray-700 dark:text-white dark:hover:text-white dark:hover:bg-gray-700">
                PowerDNS Config
               </button>
           </div>

         </div>

        </div>
       </div>
       <div class="mt-3 px-2 items-center"
        id="config_text">
         <div class="w-full text-center">
          <div id="alert_conf"
           class="text-sm mb-3 rounded-lg px-3 py-2 text-gray-900 bg-orange-200 dark:bg-orange-500 dark:text-gray-800"></div>
         </div>
         <div class="bg-white dark:bg-gray-900 mx-auto my-4 p-2 rounded-lg shadow-lg border border-gray-300 dark:border-gray-700">
          <pre id="zcloud_conf_txt"
           class="overflow-x-auto text-sm text-gray-800 dark:text-gray-200 font-mono"></pre>
          <pre id="named_conf_txt"
           class="overflow-x-auto text-sm text-gray-800 dark:text-gray-200 font-mono"></pre>
          <pre id="pdns_conf_txt"
           class="overflow-x-auto text-sm text-gray-800 dark:text-gray-200 font-mono"></pre>
         </div>
        </div>
        <div class="bg-gray-50 dark:bg-slate-800 px-4 py-3 sm:flex sm:flex-row-reverse sm:px-6">
         <button type="button"
          class="mt-3 inline-flex items-center px-4 py-2 text-sm font-medium text-gray-900 bg-white border border-gray-200 rounded-lg hover:bg-gray-100 dark:bg-gray-800 dark:border-gray-700 dark:text-white dark:hover:text-white dark:hover:bg-gray-700"
          @click="open = false">Close</button>
        </div>
      </div>

    </div>
   </div>
  </div>

  <div class="mt-4 flex-1 border-l-2 border-indigo-400 flex-col bg-white dark:bg-slate-900 rounded-md drop-shadow-md animate-slide-up-fade-in">
   <div class="p-4">
    <div class="flex md:flex-row flex-col my-3 text-center gap-2">
     <div class="flex-1">
      <a href="{{ route('add-server') }}"
       class="inline-flex items-center  px-4 py-2 text-sm font-medium text-gray-900 bg-white border border-gray-200 rounded-lg hover:bg-gray-100 dark:bg-gray-800 dark:border-gray-700 dark:text-white dark:hover:text-white dark:hover:bg-gray-700">
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" class="size-5 me-2">
         <path d="M10.75 4.75a.75.75 0 0 0-1.5 0v4.5h-4.5a.75.75 0 0 0 0 1.5h4.5v4.5a.75.75 0 0 0 1.5 0v-4.5h4.5a.75.75 0 0 0 0-1.5h-4.5v-4.5Z" />
        </svg>
        Add server
       </a>
     </div>
     @if(count($clusters) > 0)
     <div class="flex-1">
      <div id="msg_cluster"></div>
      <div class="flex justify-center">
       <button
        class="inline-flex items-center px-4 py-2 text-sm font-medium text-gray-900 bg-white border-s border-y border-gray-200 rounded-s-lg hover:bg-gray-100 dark:bg-gray-800 dark:border-gray-700 dark:text-white dark:hover:text-white dark:hover:bg-gray-700"
        id="btn_cluster_recheck">
         <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" class="size-5 me-2">
          <path fill-rule="evenodd" d="M15.312 11.424a5.5 5.5 0 0 1-9.201 2.466l-.312-.311h2.433a.75.75 0 0 0 0-1.5H3.989a.75.75 0 0 0-.75.75v4.242a.75.75 0 0 0 1.5 0v-2.43l.31.31a7 7 0 0 0 11.712-3.138.75.75 0 0 0-1.449-.39Zm1.23-3.723a.75.75 0 0 0 .219-.53V2.929a.75.75 0 0 0-1.5 0V5.36l-.31-.31A7 7 0 0 0 3.239 8.188a.75.75 0 1 0 1.448.389A5.5 5.5 0 0 1 13.89 6.11l.311.31h-2.432a.75.75 0 0 0 0 1.5h4.243a.75.75 0 0 0 .53-.219Z" clip-rule="evenodd" />
         </svg>
         Force recheck cluster
        </button>
        <select id="cluster_recheck"
         class="items-center px-4 py-2 text-sm font-medium text-gray-900 bg-white border-e border-y border-gray-200 rounded-e-lg hover:bg-gray-100 dark:bg-gray-800 dark:border-gray-700 dark:text-white dark:hover:text-white dark:hover:bg-gray-700">
          <option value="all">{{ __('All clusters') }}</option>
          @foreach($clusters as $cluster)
          <option value="{{ $cluster->id }}">{{ $cluster->name }}</option>
          @endforeach
         </select>
      </div>
     </div>
     @endif
    </div>
    @if (count($servers) === 0)
    <div class="text-center my-2">
     <span class="font-semibold p-2 dark:text-orange-400 text-orange-600 border border-orange-400 rounded-md">No servers found.</span>
    </div>
    @else
    <div id="msg"></div>
    <div class="overflow-x-auto py-5 text-slate-900 dark:text-slate-200">
     <table class="border-collapse table-auto w-full text-sm">
      <thead>
       <tr class="text-center">
        <th class="p-2">Name</th>
        <th class="p-2">Token</th>
        <th class="p-2">Type</th>
        <th class="p-2">IP</th>
        <th class="p-2">Zones</th>
        <th class="p-2">Cluster</th>
        <th class="p-2">License</th>
        <th class="p-2"></th>
       </tr>
      </thead>
      <tbody>
       @foreach ($servers as $server)
       <tr class="border-y border-slate-200 dark:border-slate-600 text-center">
        <td class="p-1 ">{{ $server->name }}</td>
        <td class="p-1" x-data="{show: false}">
         <button x-on:click="show = true" x-show="!show" class="border border-slate-900 dark:border-slate-300 rounded-full px-2">
          <svg xmlns="http://www.w3.org/2000/svg"
           viewBox="0 0 16 16"
           fill="currentColor"
           class="size-4">
            <path d="M8 9.5a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3Z" />
            <path fill-rule="evenodd"
             d="M1.38 8.28a.87.87 0 0 1 0-.566 7.003 7.003 0 0 1 13.238.006.87.87 0 0 1 0 .566A7.003 7.003 0 0 1 1.379 8.28ZM11 8a3 3 0 1 1-6 0 3 3 0 0 1 6 0Z"
             clip-rule="evenodd" />
           </svg>
         </button>
         <span class="text-xs hover:cursor-pointer" x-show="show" x-on:click="show = false">{{ $server->token }}</span>
        </td>
        <td class="p-1">{{ $server->getType() }}</td>
        <td class="p-1">{{ $server->IP }}</td>
        <td class="p-1">{{ $server->zones_count }}</td>
        <td class="p-1">{{ $server->getCluster() }}</td>
        <td class="p-1">{{ $server->license }}</td>
        <td class="p-1">
         <div class="inline-flex rounded-md shadow-sm" role="group">
          <a href="{{ route('edit-server-form', ['id' => $server->id]) }}"
           class="inline-flex items-center px-2 py-1 text-sm font-medium text-gray-900 bg-white border border-gray-200 rounded-s-lg hover:bg-gray-100 dark:bg-gray-800 dark:border-gray-700 dark:text-white dark:hover:text-white dark:hover:bg-gray-700">
            <svg class="w-4 h-4 me-2"  xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"
             class="size-6">
              <path stroke-linecap="round" stroke-linejoin="round"
               d="m16.862 4.487 1.687-1.688a1.875 1.875 0 1 1 2.652 2.652L10.582 16.07a4.5 4.5 0 0 1-1.897 1.13L6 18l.8-2.685a4.5 4.5 0 0 1 1.13-1.897l8.932-8.931Zm0 0L19.5 7.125M18 14v4.75A2.25 2.25 0 0 1 15.75 21H5.25A2.25 2.25 0 0 1 3 18.75V8.25A2.25 2.25 0 0 1 5.25 6H10" />
             </svg>

             Edit
           </a>
           <a href="{{ route('delete-server', ['id' => $server->id]) }}"
            class="inline-flex items-center px-2 py-1 text-sm font-medium text-red-900 bg-white border-t border-b border-r border-gray-200 hover:bg-gray-100 dark:bg-gray-800 dark:border-gray-700 dark:text-red-400 dark:hover:bg-gray-700">
             <svg class="w-4 h-4 me-2" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"
              class="size-6">
               <path stroke-linecap="round" stroke-linejoin="round"
                d="m14.74 9-.346 9m-4.788 0L9.26 9m9.968-3.21c.342.052.682.107 1.022.166m-1.022-.165L18.16 19.673a2.25 2.25 0 0 1-2.244 2.077H8.084a2.25 2.25 0 0 1-2.244-2.077L4.772 5.79m14.456 0a48.108 48.108 0 0 0-3.478-.397m-12 .562c.34-.059.68-.114 1.022-.165m0 0a48.11 48.11 0 0 1 3.478-.397m7.5 0v-.916c0-1.18-.91-2.164-2.09-2.201a51.964 51.964 0 0 0-3.32 0c-1.18.037-2.09 1.022-2.09 2.201v.916m7.5 0a48.667 48.667 0 0 0-7.5 0" />
              </svg>

              Delete
            </a>
            <button class="inline-flex items-center px-2 py-1 text-sm font-medium text-gray-900 bg-white border-t border-b border-gray-200 hover:bg-gray-100 dark:bg-gray-800 dark:border-gray-700 dark:text-white dark:hover:text-white dark:hover:bg-gray-700 btn_recheck" data-server_id="{{ $server->id }}">
             <svg class="w-4 h-4 me-2" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-6">
              <path stroke-linecap="round" stroke-linejoin="round" d="M16.023 9.348h4.992v-.001M2.985 19.644v-4.992m0 0h4.992m-4.993 0 3.181 3.183a8.25 8.25 0 0 0 13.803-3.7M4.031 9.865a8.25 8.25 0 0 1 13.803-3.7l3.181 3.182m0-4.991v4.99" />
             </svg>

             Recheck
            </button>
            <button @click="open = true" class="inline-flex items-center px-2 py-1 text-sm font-medium text-gray-900 bg-white border-t border-b border-s border-gray-200 hover:bg-gray-100 dark:bg-gray-800 dark:border-gray-700 dark:text-white dark:hover:text-white dark:hover:bg-gray-700 btn_config" data-server_type="{{ $server->getType() }}" data-server_name="{{ $server->name }}" data-server_id="{{ $server->id }}" data-server_license="{{ $server->license }}" data-server_token="{{ $server->token }}">
             <svg class="w-4 h-4 me-2" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-6">
              <path stroke-linecap="round" stroke-linejoin="round" d="M2.036 12.322a1.012 1.012 0 0 1 0-.639C3.423 7.51 7.36 4.5 12 4.5c4.638 0 8.573 3.007 9.963 7.178.07.207.07.431 0 .639C20.577 16.49 16.64 19.5 12 19.5c-4.638 0-8.573-3.007-9.963-7.178Z" />
              <path stroke-linecap="round" stroke-linejoin="round" d="M15 12a3 3 0 1 1-6 0 3 3 0 0 1 6 0Z" />
             </svg>

             Configuration
            </button>
            <button @click="open_install = true; type = $el.dataset.server_type;" class="inline-flex items-center px-2 py-1 text-sm font-medium text-gray-900 bg-white border border-gray-200 rounded-e-lg hover:bg-gray-100 dark:bg-gray-800 dark:border-gray-700 dark:text-white dark:hover:text-white dark:hover:bg-gray-700 btn_install" data-server_type="{{ $server->getType() }}" data-server_name="{{ $server->name }}" data-server_id="{{ $server->id }}" data-server_license="{{ $server->license }}" data-server_token="{{ $server->token }}">
             <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" class="size-5 w-4 h-4 me-2">
              <path d="M10.75 2.75a.75.75 0 0 0-1.5 0v8.614L6.295 8.235a.75.75 0 1 0-1.09 1.03l4.25 4.5a.75.75 0 0 0 1.09 0l4.25-4.5a.75.75 0 0 0-1.09-1.03l-2.955 3.129V2.75Z" />
              <path d="M3.5 12.75a.75.75 0 0 0-1.5 0v2.5A2.75 2.75 0 0 0 4.75 18h10.5A2.75 2.75 0 0 0 18 15.25v-2.5a.75.75 0 0 0-1.5 0v2.5c0 .69-.56 1.25-1.25 1.25H4.75c-.69 0-1.25-.56-1.25-1.25v-2.5Z" />
             </svg>


             Installation
            </button>
         </div>
        </td>
       </tr>
       @endforeach
      </tbody>
     </table>
    </div>
    @endif
   </div> <!-- card body -->
  </div> <!-- card -->
</div>
</div>
<script type="text/javascript">
document.addEventListener('DOMContentLoaded', function() {
 document.getElementById('menu_servers').classList.remove('text-gray-500');
 document.getElementById('menu_servers').classList.remove('hover:bg-gray-700');
 document.getElementById('menu_servers').classList.remove('hover:bg-opacity-25');
 document.getElementById('menu_servers').classList.remove('hover:text-gray-100');
 document.getElementById('menu_servers').classList.add('text-gray-100');
 document.getElementById('menu_servers').classList.add('bg-opacity-25');
 document.getElementById('menu_servers').classList.add('bg-gray-700');
 document.getElementById('menu_servers').classList.add('border-e-2');
 document.getElementById('menu_servers').classList.add('border-indigo-400');

 // CSRF token setup
 const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');

 function setupHeaders(xhr) {
  xhr.setRequestHeader('X-CSRF-TOKEN', csrfToken);
 }

 // Recheck cluster button event
 document.getElementById('btn_cluster_recheck').addEventListener('click', function() {
  const cluster = document.getElementById('cluster_recheck').value;
  const xhr = new XMLHttpRequest();
  xhr.open('POST', '/servers/recheck_cluster', true);
  setupHeaders(xhr);
  xhr.setRequestHeader('Content-Type', 'application/json;charset=UTF-8');
  xhr.onreadystatechange = function() {
   if (xhr.readyState === 4 && xhr.status === 200) {
    const response = JSON.parse(xhr.responseText);
    const msgCluster = document.getElementById('msg');
    if (response.code === 'ok') {
     msg.innerHTML = '<div \
      x-data="{ show:true }"\
      x-show="show"\
      x-init="setTimeout(() => show = false, 4000)"\
      class="rounded bg-emerald-100 p-4 text-emerald-700 md:p-5 dark:bg-emerald-900/75 dark:text-emerald-100 animate-slide-up-fade-in"\
      >\
      <div class="mb-2 flex items-center">\
      <svg\
      class="hi-solid hi-check-circle mr-3 inline-block size-5 flex-none text-emerald-500 dark:text-emerald-400"\
      fill="currentColor"\
      viewBox="0 0 20 20"\
      xmlns="http://www.w3.org/2000/svg"\
      >\
      <path\
      fill-rule="evenodd"\
      d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z"\
      clip-rule="evenodd"\
      />\
      </svg>\
      <h3 class="font-semibold">Success!</h3>\
      </div>\
      <p class="ml-8">'+
      response.message+
      '</p>\
      </div>';
    } else {
     msg.innerHTML = '<div \
      x-data="{ show:true }"\
      x-show="show"\
      x-init="setTimeout(() => show = false, 4000)"\
      class="rounded bg-orange-100 p-4 text-orange-700 md:p-5 dark:bg-orange-900/75 dark:text-orange-100 animate-slide-up-fade-in"\
      >\
      <div class="mb-2 flex items-center">\
      <h3 class="font-semibold">Error!</h3>\
      </div>\
      <p class="ml-8">'+
      response.message+
      '</p>\
      </div>';
    }
    document.querySelectorAll('.message .close').forEach(function(closeIcon) {
     closeIcon.addEventListener('click', function() {
      this.closest('.message').style.display = 'none';
     });
    });
   }
  };
  xhr.send(JSON.stringify({ cluster: cluster }));
 });

 // Recheck server button event
 document.querySelectorAll('.btn_recheck').forEach(function(button) {
  button.addEventListener('click', function() {
   const server_id = this.getAttribute('data-server_id');
   const xhr = new XMLHttpRequest();
   xhr.open('POST', '/servers/recheck', true);
   setupHeaders(xhr);
   xhr.setRequestHeader('Content-Type', 'application/json;charset=UTF-8');
   xhr.onreadystatechange = function() {
    if (xhr.readyState === 4 && xhr.status === 200) {
     const response = JSON.parse(xhr.responseText);
     const msg = document.getElementById('msg');
     if (response.code === 'ok') {
      msg.innerHTML = '<div \
       x-data="{ show:true }"\
       x-show="show"\
       x-init="setTimeout(() => show = false, 4000)"\
       class="rounded bg-emerald-100 p-4 text-emerald-700 md:p-5 dark:bg-emerald-900/75 dark:text-emerald-100 animate-slide-up-fade-in"\
       >\
       <div class="mb-2 flex items-center">\
       <svg\
       class="hi-solid hi-check-circle mr-3 inline-block size-5 flex-none text-emerald-500 dark:text-emerald-400"\
       fill="currentColor"\
       viewBox="0 0 20 20"\
       xmlns="http://www.w3.org/2000/svg"\
       >\
       <path\
       fill-rule="evenodd"\
       d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z"\
       clip-rule="evenodd"\
       />\
       </svg>\
       <h3 class="font-semibold">Success!</h3>\
       </div>\
       <p class="ml-8">'+
       response.message+
       '</p>\
       </div>';
     } else {
      msg.innerHTML = '<div \
       x-data="{ show:true }"\
       x-show="show"\
       x-init="setTimeout(() => show = false, 4000)"\
       class="rounded bg-orange-100 p-4 text-orange-700 md:p-5 dark:bg-orange-900/75 dark:text-orange-100 animate-slide-up-fade-in"\
       >\
       <div class="mb-2 flex items-center">\
       <h3 class="font-semibold">Error!</h3>\
       </div>\
       <p class="ml-8">'+
       response.message+
       '</p>\
       </div>';
     }
     document.querySelectorAll('.message .close').forEach(function(closeIcon) {
      closeIcon.addEventListener('click', function() {
       this.closest('.message').style.display = 'none';
      });
     });
    }
   };
   xhr.send(JSON.stringify({ server_id: server_id }));
  });
 });

 // Show configuration modal
 document.addEventListener('click', function(event) {
  if (event.target.classList.contains('btn_config')) {
   const server_name = event.target.getAttribute('data-server_name');
   const server_id = event.target.getAttribute('data-server_id');
   const conf_type = event.target.getAttribute('data-server_type');
   const license = event.target.getAttribute('data-server_license');
   const token = event.target.getAttribute('data-server_token');
   document.getElementById('conf_type').value = conf_type;

   const xhr = new XMLHttpRequest();
   xhr.open('POST', '{{ route("servers_show_configuration") }}', true);
   setupHeaders(xhr);
   xhr.setRequestHeader('Content-Type', 'application/json;charset=UTF-8');
   xhr.onreadystatechange = function() {
    if (xhr.readyState === 4 && xhr.status === 200) {
     const response = JSON.parse(xhr.responseText);
     document.getElementById('zcloud_conf_txt').innerHTML = response.zcloud;
     document.getElementById('named_conf_txt').innerHTML = response.named;
     document.getElementById('pdns_conf_txt').innerHTML = response.pdns;
    }
   };
   xhr.send(JSON.stringify({ server_id: server_id }));

   document.getElementById('config_text').classList.add('hidden');
  }

  if (event.target.classList.contains('btn_install')) {
   const conf_type = event.target.getAttribute('data-server_type');
   const license = event.target.getAttribute('data-server_license');
   const token = event.target.getAttribute('data-server_token');

   //show auto conf command
   if (conf_type == "Agent")
    var auto_conf_type = "agent";
    else
    var auto_conf_type = "node";

   var auto_conf = `bash <(curl -fsSL https://repo.nixpal.com/zcloud-installer.sh) ${auto_conf_type} server_hostname="{{ preg_replace("/http[s]:\/\//","",env('APP_URL')) }}" token="${token}" license="${license}"`;
   document.getElementById('auto_conf').innerHTML = auto_conf;
  }
 });

 // Handle configuration modal buttons
 document.getElementById('config_modal').addEventListener('click', function(event) {
  if (event.target.classList.contains('btn_conf')) {
   const conf = event.target.getAttribute('data-conf_id');
   const alertConf = document.getElementById('alert_conf');
   // alertConf.style.display = 'block';
   document.getElementById('config_text').classList.remove('hidden');

   if (conf === 'zcloud_conf') {
    if (document.getElementById('conf_type').value === 'Agent') {
     alertConf.innerHTML = 'Configuration file location: /etc/zcloudagent.conf';
    } else {
     alertConf.innerHTML = 'Configuration file location: /etc/zcloudnode.conf';
    }
    document.getElementById('zcloud_conf_txt').style.display = 'block';
    document.getElementById('named_conf_txt').style.display = 'none';
    document.getElementById('pdns_conf_txt').style.display = 'none';
   } else if (conf === 'pdns_conf') {
    alertConf.innerHTML = 'Configuration file location: /etc/pdns/pdns.conf';
    document.getElementById('zcloud_conf_txt').style.display = 'none';
    document.getElementById('named_conf_txt').style.display = 'none';
    document.getElementById('pdns_conf_txt').style.display = 'block';
   } else if (conf === 'named_conf') {
    alertConf.innerHTML = 'Configuration file location: /etc/named.conf';
    document.getElementById('zcloud_conf_txt').style.display = 'none';
    document.getElementById('named_conf_txt').style.display = 'block';
    document.getElementById('pdns_conf_txt').style.display = 'none';
   }
  }
 });
});

</script>
@endsection
