@extends('layouts.app')
@section('title') Add server @endsection
@section('content')


<div class="flex flex-row max-lg:flex-col my-4 animate-slide-up-fade-in">
  <div class="flex-1 border-s-2 border-indigo-400 flex-col bg-white dark:bg-slate-900  rounded-lg px-4 py-10 drop-shadow-md">
    @if($errors->any())
      <div 
        class="rounded bg-orange-100 p-4 text-orange-700 md:p-5 dark:bg-orange-900/75 dark:text-orange-100 animate-slide-up-fade-in">
        <div class="mb-2 flex items-center">
          <h3 class="font-semibold">Error!</h3>
        </div>
        <p class="ml-8">
          <ul class="leading-relaxed">
          @foreach ($errors->all() as $error)
            <li>
              {{$error}}
            </li>
          @endforeach
          </ul>
        </p>
      </div>
    @endif
    @if(count($clusters) === 0)
      <div class="text-center">
        <span class="px-4 py-2 bg-orange-200 rounded-lg text-slate-800 dark:bg-orange-500 dark:text-slate-900">No clusters were found. You have to create a cluster before adding a server.</span>
      </div>
      <div class="flex-1 text-center mt-3">
        <a href="{{ route('add-cluster-form') }}"
          class="inline-flex items-center  px-4 py-2 text-sm font-medium text-gray-900 bg-white border border-gray-200 rounded-lg hover:bg-gray-100 hover:text-blue-700 focus:z-10 focus:ring-2 focus:ring-blue-700 focus:text-blue-700 dark:bg-gray-800 dark:border-gray-700 dark:text-white dark:hover:text-white dark:hover:bg-gray-700 dark:focus:ring-blue-500 dark:focus:text-white">
          <svg xmlns="http://www.w3.org/2000/svg"
              viewBox="0 0 20 20"
              fill="currentColor"
              class="size-5 me-2">
            <path d="M10.75 4.75a.75.75 0 0 0-1.5 0v4.5h-4.5a.75.75 0 0 0 0 1.5h4.5v4.5a.75.75 0 0 0 1.5 0v-4.5h4.5a.75.75 0 0 0 0-1.5h-4.5v-4.5Z" />
          </svg>
          Add cluster
        </a>
      </div>
    @else
    <form method="POST" action="">
      <div class="grid gap-6 mb-6 lg:grid-cols-3">
        <div>
          <label for="name"
                class="block mb-2 text-sm font-medium text-gray-900 dark:text-gray-300">Server name</label>
          <input type="text"
                id="name"
                name="name"
                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"
                placeholder="server101 or server101.mycomp.tld"
                required
                autofocus>
        </div>
        <div>
          <label for="token"
                class="block mb-2 text-sm font-medium text-gray-900 dark:text-gray-300">Token</label>
          <div class="inline-flex items-center  block w-full">
            <input type="text"
              id="token"
              class="bg-gray-50 border-s border-y border-gray-300 text-gray-900 text-sm rounded-s-lg focus:ring-blue-500 focus:border-blue-500  block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"
              placeholder=""
              required
              name="token"
              readonly>
            <button id="tokenGenerator"
            type="button"
            class="bg-gray-50 border-x border-y border-gray-300 text-gray-900 text-sm rounded-e-lg focus:ring-blue-500 focus:border-blue-500  p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 dark:hover:text-white dark:hover:bg-gray-700 hover:bg-gray-100">
              Generate
            </button>
          </div>
        </div>
        <div>
          <label for="IP"
                class="block mb-2 text-sm font-medium text-gray-900 dark:text-gray-300">Server IP</label>
          <input type="text"
                id="IP"
                name="IP"
                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"
                placeholder="192.168.1.1"
                required>
        </div>
      </div>
      <div class="grid gap-6 mb-6 lg:grid-cols-6">
        <div>
          <fieldset>
            <legend class="block mb-2 text-sm font-medium text-gray-900 dark:text-gray-300">Type</legend>
            <div class="mt-2">
              <div class="flex items-center gap-x-3">
                <input checked="checked" id="type-agent" type="radio" name="type" value="1" class="h-4 w-4">
                <label for="type-agent" class="block text-sm font-medium leading-6 text-gray-900 dark:text-gray-300">Agent</label>
              </div>
              <div class="flex items-center gap-x-3">
                <input id="type-node" class="h-4 w-4" type="radio" name="type" value="2">
                <label for="type-node" class="block text-sm font-medium leading-6 text-gray-900 dark:text-gray-300">Node</label>
              </div>
            </div>
          </fieldset>
        </div>
        <div>
          <label class="block mb-2 text-sm font-medium text-gray-900 dark:text-gray-300">Cluster</label>

          <select class="items-center px-4 py-2 text-sm font-medium text-gray-900 bg-white border border-gray-200 rounded-lg hover:bg-gray-100 focus:z-10 focus:ring-2 focus:ring-blue-700 focus:text-blue-700 dark:bg-gray-800 dark:border-gray-700 dark:text-white dark:hover:text-white dark:hover:bg-gray-700 dark:focus:ring-blue-500 dark:focus:text-white" name="cluster_id">
                        @foreach ($clusters as $cluster)
                          <option value="{{ $cluster->id }}">{{ $cluster->name }}</option>
                        @endforeach
            </select>
        </div>
      </div>
      <hr class="border-slate-200 dark:border-slate-700"></hr>
      <div class="text-center mt-4">
        @csrf
        <input type="submit" class="px-4 py-2 text-m font-medium text-gray-900 bg-white border border-gray-200 rounded-lg hover:bg-gray-100 focus:z-10 focus:ring-2 focus:ring-blue-700 focus:text-blue-700 dark:bg-gray-800 dark:border-gray-700 dark:text-white dark:hover:text-white dark:hover:bg-gray-700 dark:focus:ring-blue-500 dark:focus:text-white" value="Add">
      </div>
    </form>
    @endif
  </div>
</div>
<script type="text/javascript">
document.addEventListener('DOMContentLoaded', function() {

  document.getElementById('menu_servers').classList.remove('text-gray-500');
  document.getElementById('menu_servers').classList.remove('hover:bg-gray-700');
  document.getElementById('menu_servers').classList.remove('hover:bg-opacity-25');
  document.getElementById('menu_servers').classList.remove('hover:text-gray-100');
  document.getElementById('menu_servers').classList.add('text-gray-100');
  document.getElementById('menu_servers').classList.add('bg-opacity-25');
  document.getElementById('menu_servers').classList.add('bg-gray-700');

// set the length of the string
var stringLength = 32;

// list containing characters for the random string
var stringArray = ['0','1','2','3','4','5','6','7','8','9','a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z','A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z'];
  
  document.getElementById('tokenGenerator').addEventListener('click', function() {

    var rndString = "";

    // build a string with random characters
    for (var i = 1; i < stringLength; i++) { 
        var rndNum = Math.ceil(Math.random() * stringArray.length) - 1;
        rndString = rndString + stringArray[rndNum];
    };
    document.getElementById('token').value = rndString;

});
document.getElementById('tokenGenerator').click();
});
</script>
@endsection
 
