@extends('layouts.app')
@section('title') Reset password @endsection
@section('content')

<div class="flex gap-3 flex-col my-4 animate-slide-up-fade-in items-center ">
  <div class="flex-1 justify-between lg:w-1/3 border-t border-slate-300 dark:border-slate-700 flex-col bg-white dark:bg-slate-900  rounded-lg shadow-md p-4 hover:shadow-lg hover:transition-all">
    <form method="POST" action="{{ route('password.email') }}">
      @csrf
      <div class="p-5 grid gap-3 justify-items-center">
        <div>
          <img src="/images/logo.png" alt="zone Cloud logo"
                class="dark:invert dark:bg-transparent">
        </div>
        <div class="text-center">
          <span class="text-sm">Fill in your account's email address.<br/>A password reset link will be emailed to you, <span class="underline font-medium">if your account exists</span>.</span>
        </div>
        <div class="w-full">
          <input class="bg-gray-50 border border-gray-300 text-gray-900 w-full rounded-lg block py-2 px-4 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white" id="email" type="email" name="email" value="{{ old('email') }}" required autocomplete="email" autofocus placeholder="E-mail">
        </div>
        <div>
          <button class="bg-gray-100 border border-gray-300 text-gray-900 p-2 text-base rounded-md dark:bg-gray-600 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:hover:text-white dark:hover:bg-gray-700 hover:bg-gray-200" type="submit">Send email</button>
        </div>
      </div>
    </form>
  </div>
</div>
@endsection
