@extends('layouts.app')
@section('title') Edit server @endsection
@section('content')
<div class="flex flex-row max-lg:flex-col my-4 animate-slide-up-fade-in">
  <div class="flex-1 border-s-2 border-indigo-400 flex-col bg-white dark:bg-slate-900  rounded-lg px-4 py-10 drop-shadow-md">
    @if ($server->isEmpty())
      <div 
        class="rounded bg-orange-100 p-4 text-orange-700 md:p-5 dark:bg-orange-800 dark:text-orange-100 animate-slide-up-fade-in">
        <div class="mb-2 flex items-center">
          <h3 class="font-semibold">Error!</h3>
        </div>
        <p class="ml-8">
          Server not found
        </p>
      </div>
    @else

    <form method="POST" action="">
      <div class="grid gap-6 mb-6 lg:grid-cols-3">
        <div>
          <label for="name"
                class="block mb-2 text-sm font-medium ">Server name</label>
          <input type="text"
                id="name"
                name="name"
                class="bg-gray-50 border border-gray-300  text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 "
                placeholder="server101 or server101.mycomp.tld"
                value="{{ $server[0]->name }}"
                required
                autofocus>
        </div>
        <div>
          <label for="token"
                class="block mb-2 text-sm font-medium ">Token</label>
          <div class="inline-flex items-center  block w-full">
            <input type="text"
              id="token"
              class="bg-gray-50 border-s border-y border-gray-300  text-sm rounded-s-lg focus:ring-blue-500 focus:border-blue-500  block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 "
              placeholder=""
              required
              name="token"
              value="{{ $server[0]->token }}"
              readonly>
            <button id="tokenGenerator"
            type="button"
            class="bg-gray-50 border-x border-y border-gray-300  text-sm rounded-e-lg focus:ring-blue-500 focus:border-blue-500  p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400  dark:hover:text-white dark:hover:bg-gray-700 hover:bg-gray-100">
              Generate
            </button>
          </div>
        </div>
        <div>
          <label for="IP"
                class="block mb-2 text-sm font-medium ">Server IP</label>
          <input type="text"
                id="IP"
                name="IP"
                value="{{ $server[0]->IP }}"
                class="bg-gray-50 border border-gray-300  text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 "
                placeholder="192.168.1.1"
                required>
        </div>
      </div>
      <div class="grid gap-6 mb-6 lg:grid-cols-6">
        <div>
          <fieldset>
            <legend class="block mb-2 text-sm font-medium ">Type</legend>
            <div class="mt-2">
              <div class="flex items-center gap-x-3">
                <input @if ($server[0]->type === 1) checked @endif id="type-agent" type="radio" name="type" value="1" class="h-4 w-4">
                <label for="type-agent" class="block text-sm font-medium leading-6 ">Agent</label>
              </div>
              <div class="flex items-center gap-x-3">
                <input @if ($server[0]->type === 2) checked @endif id="type-node" class="h-4 w-4" type="radio" name="type" value="2">
                <label for="type-node" class="block text-sm font-medium leading-6 ">Node</label>
              </div>
            </div>
          </fieldset>
        </div>
        <div>
          <label class="block mb-2 text-sm font-medium ">Cluster</label>

          <select class="items-center px-4 py-2 text-sm font-medium  bg-white border border-gray-200 rounded-lg focus:z-10 dark:bg-gray-800 dark:border-gray-700" name="cluster_id">
                        @foreach ($clusters as $cluster)
                          <option value="{{ $cluster->id }}" @if ( $server[0]->cluster_id == $cluster->id ) selected @endif>{{ $cluster->name }}</option>
                        @endforeach
            </select>
        </div>
      </div>
      <hr class="border-slate-200 dark:border-slate-700"></hr>
      <div class="text-center mt-4">
        @csrf
        <input type="submit" class="px-4 py-2 text-m font-medium  bg-white border border-gray-200 rounded-lg dark:bg-gray-800 dark:border-gray-700 hover:bg-gray-100 dark:hover:bg-gray-700" value="Save">
      </div>
    </form>
    @endif
  </div>
</div>
<script type="text/javascript">
document.addEventListener('DOMContentLoaded', function() {

  document.getElementById('menu_servers').classList.remove('text-gray-500');
  document.getElementById('menu_servers').classList.remove('hover:bg-gray-700');
  document.getElementById('menu_servers').classList.remove('hover:bg-opacity-25');
  document.getElementById('menu_servers').classList.remove('hover:text-gray-100');
  document.getElementById('menu_servers').classList.add('text-gray-100');
  document.getElementById('menu_servers').classList.add('bg-opacity-25');
  document.getElementById('menu_servers').classList.add('bg-gray-700');

// set the length of the string
var stringLength = 32;

// list containing characters for the random string
var stringArray = ['0','1','2','3','4','5','6','7','8','9','a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z','A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z'];
  
  document.getElementById('tokenGenerator').addEventListener('click', function() {

    var rndString = "";

    // build a string with random characters
    for (var i = 1; i < stringLength; i++) { 
        var rndNum = Math.ceil(Math.random() * stringArray.length) - 1;
        rndString = rndString + stringArray[rndNum];
    };
    document.getElementById('token').value = rndString;

  });
});
</script>
@endsection
 
