@extends('layouts.app')
@section('title') IP Info tool @endsection
@section('content')
  <!-- Notification -->
  <div x-data="notification()" x-init="init(); notification_success = true">
    <div
      x-cloak
      x-show="isVisible"
      x-transition:enter="transition ease-out duration-300"
      x-transition:enter-start="opacity-0 transform translate-y-2"
      x-transition:enter-end="opacity-100 transform translate-y-0"
      x-transition:leave="transition ease-in duration-200"
      x-transition:leave-start="opacity-100 transform translate-y-0"
      x-transition:leave-end="opacity-0 transform translate-y-2"
      class="fixed inset-x-0 top-3 z-20 flex items-center justify-center px-4 py-6 pointer-events-none sm:p-6 sm:items-start sm:justify-center"
    >
      <div :class="notification_success ? 'bg-green-600' : 'bg-red-600'" class="max-w-sm w-full shadow-lg text-white rounded-lg pointer-events-auto">
        <div class="p-4">
          <p class="text-sm text-center" x-text="message"></p>
        </div>
      </div>
    </div>
  </div>
  <!-- Notification -->

<div x-data="{show_info: false}" class="flex gap-3 flex-col my-4 animate-slide-up-fade-in text-gray-700 dark:text-gray-400">
  <div class="flex-1 justify-between h-fit border-2 border-cyan-700 dark:border-cyan-200 flex-col bg-white dark:bg-slate-900  rounded-md shadow-md p-4 hover:shadow-lg hover:transition-all">
    <div class="cursor-pointer" x-on:click="show_info = !show_info">
      <span class="text-lg inline-flex items-center">
        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-6 mr-2 dark:stroke-cyan-200 stroke-cyan-700">
          <path stroke-linecap="round" stroke-linejoin="round" d="m11.25 11.25.041-.02a.75.75 0 0 1 1.063.852l-.708 2.836a.75.75 0 0 0 1.063.853l.041-.021M21 12a9 9 0 1 1-18 0 9 9 0 0 1 18 0Zm-9-3.75h.008v.008H12V8.25Z" />
        </svg>
        Info
      </span>
    </div>
    <div x-cloak x-show="show_info" class="animate-slide-down-fade-in">
      <p>We're excited to introduce a powerful new tool to enhance your security log analysis.</p>
      <p>Our IP Info tool allows you to:</p>
      <ul class="list-inside list-disc my-2">
        <li>Input text from your security logs</li>
        <li>Automatically extract all IP addresses</li>
        <li>Instantly receive geolocation data for each IP</li>
      </ul>
      <p>This tool uses MaxMind DB and you need to obtain a key to use it. A <strong>free</strong> key can be obtained through <a href="https://www.maxmind.com/" target="_blank" class="underline">MaxMind's website</a></a>.</p>
    </div>
  </div>
</div>

<div x-data="{show_results: false}">
  <div class="text-slate-900 dark:text-slate-200">
    @if ( !$maxmind_license_exists )
    <div class="flex gap-3 flex-col my-4 animate-slide-up-fade-in">
      <div class="flex-1 justify-between h-fit border-s-2 border-orange-700 dark:border-organge-200 flex-col bg-white dark:bg-slate-900  rounded-lg shadow-md p-4 hover:shadow-lg hover:transition-all overflow-x-auto">
        <div class="font-bold text-xl text-orange-600 dark:text-orange-400">Missing MaxMind license key</div>
        <p>To use this feature you have to edit your <code class="font-mono bg-gray-200 px-2 dark:bg-gray-700 rounded">.env</code> file and insert a <code class="font-mono bg-gray-200 px-2 dark:bg-gray-700 rounded">MAXMIND_LICENSE_KEY="&lt;LICENSE_KEY&gt;"</code> line.</p>
      </div>
    </div>
    @endif
    <div class="flex justify-center">
      <button
        onclick="update_geoip_db()"
        class="items-center animate-slide-up-fade-in px-4 py-2 text-sm font-medium text-gray-900 bg-white border border-gray-200 rounded-md hover:bg-gray-100 dark:bg-gray-800 dark:border-gray-700 dark:text-white dark:hover:text-white dark:hover:bg-gray-700 disabled:dark:bg-gray-600 disabled:bg-gray-100 @if(!$maxmind_license_exists) {{ "cursor-not-allowed" }} @endif" @if(!$maxmind_license_exists) {{ "disabled" }} @endif >Initialize or Update geoip DB</button>
    </div>
    <div class="flex gap-3 flex-row max-lg:flex-col my-4 animate-slide-up-fade-in text-slate-900 dark:text-slate-200">
    <div class="flex-1 justify-between h-fit border-s-2 border-indigo-400 flex-col bg-white dark:bg-slate-900  rounded-md drop-shadow-md p-4 hover:shadow-lg hover:transition-all">
      <textarea class="w-full border border-slate-700 dark:border-slate-200 dark:bg-slate-700 p-3 font-mono text-xs rounded-md" id="ips_text" rows="5" placeholder="text goes here"></textarea>
      <div class="my-2">
        <button @click='get_ip_info; show_results=true;' {{ $maxmind_db_initialized ? '' : 'disabled' }} class="disabled:cursor-not-allowed px-4 py-2 text-sm font-medium text-gray-900 bg-white border border-gray-200 rounded-lg hover:bg-gray-100 dark:bg-gray-800 dark:border-gray-700 dark:text-white dark:hover:text-white dark:hover:bg-gray-700" id="btnStart" >Get IP info</button>
        @if( !$maxmind_db_initialized )
        <span class="italic text-sm">GeoIP database <span class="font-semibold">not initialized</span>. You have to initialize the database before fetching results. If you have already initialized the database, refresh this page.</span>
        @endif
      </div>
    </div>
  </div>
  </div>

  <div x-show="show_results" class="flex gap-3 flex-row max-lg:flex-col my-4 animate-slide-up-fade-in">
    <div class="flex-1 justify-between h-fit border-s-2 border-indigo-400 flex-col bg-white dark:bg-slate-900  rounded-md drop-shadow-md p-4 hover:shadow-lg hover:transition-all">
    <table id="results_table" class="table-auto w-full overflow-x-auto">
        <thead>
          <tr>
            <th>IP</th>
            <th>Country</th>
          </tr>
        </thead>
      </table>
    </div>
  </div>
</div>

<script>
  const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
document.addEventListener('DOMContentLoaded', function () {
    document.getElementById('menu_tools').classList.remove('text-gray-500');
    document.getElementById('menu_tools').classList.remove('hover:bg-gray-700');
    document.getElementById('menu_tools').classList.remove('hover:bg-opacity-25');
    document.getElementById('menu_tools').classList.remove('hover:text-gray-100');
    document.getElementById('menu_tools').classList.add('text-gray-100');
    document.getElementById('menu_tools').classList.add('bg-opacity-25');
    document.getElementById('menu_tools').classList.add('bg-gray-700');
    document.getElementById('menu_tools_ipinfo').classList.remove('text-gray-500');
    document.getElementById('menu_tools_ipinfo').classList.remove('hover:bg-gray-700');
    document.getElementById('menu_tools_ipinfo').classList.remove('hover:bg-opacity-25');
    document.getElementById('menu_tools_ipinfo').classList.remove('hover:text-gray-100');
    document.getElementById('menu_tools_ipinfo').classList.add('text-gray-100');
    document.getElementById('menu_tools_ipinfo').classList.add('bg-opacity-25');
    document.getElementById('menu_tools_ipinfo').classList.add('bg-gray-700');
    document.getElementById('menu_tools_ipinfo').classList.add('border-e-2');
    document.getElementById('menu_tools_ipinfo').classList.add('border-indigo-400');
    window.dispatchEvent(new CustomEvent('open-tools-menu'));

    results_table = new DataTable("#results_table",
      {
        perPageSelect: [20, 100, 500, ["All", 0]],
        rowRender: (row, tr, _index) => {
          tr.attributes.class = "hover:bg-slate-200 dark:hover:bg-slate-700";
          if (tr.childNodes) {
            tr.childNodes.forEach(td => {
              td.attributes.class = "border-b border-slate-200 dark:border-slate-600 p-1 text-slate-900 dark:text-slate-400 text-sm text-center";
            });
          }
        },
        data: {
          headings: [
            {
              text: 'IP',
              data: 'ip'
            },
            {
              text: 'Country',
              data: 'cc',
            }
          ],
        },
        columns: [
          {
            select: 0,
            type: "string",
            data: 'ip',
          },
          {
            select: 1,
            type: "string",
            data: 'cc',
          },
        ]
      }
    );
});

  function update_geoip_db()
  {
    fetch("{{ route("update_geoip") }}",
    {
      method: "GET",
      headers: {
        'X-CSRF-TOKEN': csrfToken,
        'Content-Type': 'application/json'
      },
    })
    .then( response => response.text() )
    .then(response => {
      showNotification(response,true);
    })
  }

  function get_ip_info()
  {
    var ips_text = document.getElementById('ips_text').value;
    fetch("{{ route('ipinfo_check') }}", {
      method: 'POST',
      headers: {
        'X-CSRF-TOKEN': csrfToken,
        'Content-Type': 'application/json'
      },
      body: JSON.stringify({ ips_text: ips_text })
    })
    .then(response => response.json())
    .then(response => {
      results_table.data.data = [];
      results_table.insert(response.result);
    })
  }
  function notification() {
    return {
      isVisible: false,
      notification_status: true,
      message: '',
      init() {
        window.showNotification = this.show.bind(this);
      },
      show(msg, status) {
        this.message = msg;
        this.notification_success = status;
        this.isVisible = true;
        delay = status ? 3000 : 6000;
        setTimeout(() => {
          this.isVisible = false;
        }, delay);
      }
    }
  }
</script>
@endsection

 
