<?php

declare(strict_types=1);

namespace Codedge\Updater\Notifications\Notifications;

use Codedge\Updater\Events\UpdateAvailable as UpdateAvailableEvent;
use Codedge\Updater\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

final class UpdateAvailable extends BaseNotification
{
    /**
     * @var UpdateAvailableEvent
     */
    protected $event;

    public function toMail(): MailMessage
    {
        return (new MailMessage())
            ->from(config('self-update.notifications.mail.from.address', config('mail.from.address')), config('self-update.notifications.mail.from.name', config('mail.from.name')))
            ->subject(config('app.name').': Update available');
    }

    public function setEvent(UpdateAvailableEvent $event): self
    {
        $this->event = $event;

        return $this;
    }
}
