@extends('layouts.app')
@section('title') Edit cluster @endsection
@section('content')

<div class="flex flex-row max-lg:flex-col my-4 animate-slide-up-fade-in">
  <div class="flex-1 border-s-2 border-indigo-400 flex-col bg-white dark:bg-slate-900  rounded-lg px-4 py-10 drop-shadow-md">
    @if(!$cluster)
        <div class="alert alert-warning">
          Cluster not found.
        </div>
    @else
    <form method="POST" action="">
      <div class="grid gap-6 mb-6 lg:grid-cols-2">
        <div>
          <label for="name"
                class="block mb-2 text-sm font-medium ">Cluster name</label>
          <input type="text"
                id="name"
                name="name"
                value="{{ $cluster->name }}"
                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"
                placeholder="Cluster name"
                required
                autofocus>
        </div>
        <div>
            <label class="block mb-2 text-sm font-medium ">Notifications</label>
            <div class="mt-2">
              <div class="flex items-center gap-x-3">
                <input type="checkbox" @if ($cluster->email_notifications) {{ __('checked') }} @endif name="notification" id="notification" class="h-4 w-4">
                <label for="notification" class="block text-sm font-medium leading-6 ">Enable notifications</label>
              </div>
            </div>
        </div>
      </div>
      <hr class="border-slate-200 dark:border-slate-700"></hr>
      <div class="text-center mt-4">
        @csrf
        <input type="submit" class="px-4 py-2 text-m font-medium text-gray-900 bg-white border border-gray-200 rounded-lg hover:bg-gray-100 dark:bg-gray-800 dark:border-gray-700 dark:text-white dark:hover:bg-gray-700" value="Save">
      </div>
    </form>
    @endif
  </div>
</div>
<script>
  document.addEventListener('DOMContentLoaded', function () {
    document.getElementById('menu_clusters').classList.remove('text-gray-500');
    document.getElementById('menu_clusters').classList.remove('hover:bg-gray-700');
    document.getElementById('menu_clusters').classList.remove('hover:bg-opacity-25');
    document.getElementById('menu_clusters').classList.remove('hover:text-gray-100');
    document.getElementById('menu_clusters').classList.add('text-gray-100');
    document.getElementById('menu_clusters').classList.add('bg-opacity-25');
    document.getElementById('menu_clusters').classList.add('bg-gray-700');
  });
</script>
@endsection
 
