<div x-cloak
       @keydown.window.escape="open = false"
       x-show="open"
       class="relative z-10"
       aria-labelledby="modal-title"
       x-ref="dialog"
       aria-modal="true">
  
    <div x-show="open"
         x-transition:enter="ease-out duration-300"
         x-transition:enter-start="opacity-0"
         x-transition:enter-end="opacity-100"
         x-transition:leave="ease-in duration-200"
         x-transition:leave-start="opacity-100"
         x-transition:leave-end="opacity-0"
         x-description="Background backdrop, show/hide based on modal state."
         class="fixed inset-0 bg-gray-500 bg-opacity-75 transition-opacity"
         aria-hidden="true"></div>
  
  
    <div class="fixed inset-0 z-10 w-screen overflow-y-auto">
      <div class="flex min-h-full items-end justify-center p-4 text-center items-center sm:p-0">
        <div x-show="open"
             x-transition:enter="ease-out duration-300"
             x-transition:enter-start="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
             x-transition:enter-end="opacity-100 translate-y-0 sm:scale-100"
             x-transition:leave="ease-in duration-200"
             x-transition:leave-start="opacity-100 translate-y-0 sm:scale-100"
             x-transition:leave-end="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
             x-description="Modal panel, show/hide based on modal state."
             class="relative transform overflow-hidden rounded-lg border-t-2 border-cyan-600 bg-white dark:bg-slate-800 text-left shadow-xl transition-all my-8 w-full max-w-lg"
             @click.away="open = false">
          <div class="bg-white dark:bg-slate-800 px-4 pb-4 pt-5 sm:p-6 sm:pb-4">
            <div class="flex flex-col items-start">
              <div class="mt-2 w-full text-center sm:text-left text-gray-900 dark:text-white">
                <h3 class="text-lg font-semibold leading-6 text-center"
                    id="modal-title">
                    DNS check for zone <span x-text="zone" class="underline"></span>
                </h3>
                <hr class="border-slate-200 dark:border-slate-700 my-3">
                <div class="text-center"
                      role="group">
                  <button
                      x-on:click="getZoneInfo(zone,'A')"
                      class="dig_a inline-flex items-center px-2 py-2 text-sm font-medium text-gray-900 bg-white border border-gray-200 rounded-s-lg hover:bg-gray-100 dark:bg-gray-800 dark:border-gray-700 dark:text-white dark:hover:text-white dark:hover:bg-gray-700">
                    A
                  </button><button
                      x-on:click="getZoneInfo(zone,'MX')"
                      class="dig_mx #table_duplicate_zonesinline-flex items-center px-2 py-2 text-sm font-medium text-gray-900 bg-white border-y border-gray-200  hover:bg-gray-100 dark:bg-gray-800 dark:border-gray-700 dark:text-white dark:hover:text-white dark:hover:bg-gray-700">
                    MX
                  </button><button
                      x-on:click="getZoneInfo(zone,'NS')"
                      class="dig_ns inline-flex items-center px-2 py-2 text-sm font-medium text-gray-900 bg-white border rounded-e-lg border-gray-200 hover:bg-gray-100 dark:bg-gray-800 dark:border-gray-700 dark:text-white dark:hover:bg-gray-700">
                    NS
                  </button>
                </div>
              </div>
              <div class="my-2 w-full">
                <div id="dig_results" class="overflow-x-auto animate-slide-up-fade-in bg-gray-100 border border-gray-200 dark:border-gray-700 dark:bg-black p-2 text-black dark:text-white w-full rounded-md font-mono text-xs">
                </div>
              </div>
            </div>
          </div>
        </div>
  
      </div>
    </div>
  </div>