@extends('layouts.app')
@section('title') Blacklist reports @endsection
@section('content')
<div x-data="{ open: false, server_name: '', bl_data: [] }">

<div x-cloak
       @keydown.window.escape="open = false"
       x-show="open"
       class="relative z-10"
       aria-labelledby="modal-title"
       x-ref="dialog"
       aria-modal="true">
  
    <div x-show="open"
         x-transition:enter="ease-out duration-300"
         x-transition:enter-start="opacity-0"
         x-transition:enter-end="opacity-100"
         x-transition:leave="ease-in duration-200"
         x-transition:leave-start="opacity-100"
         x-transition:leave-end="opacity-0"
         x-description="Background backdrop, show/hide based on modal state."
         class="fixed inset-0 bg-gray-500 bg-opacity-75 transition-opacity"
         aria-hidden="true"></div>
  
  
    <div class="fixed inset-0 z-10 w-screen overflow-y-auto">
      <div class="flex min-h-full items-end justify-center p-4 text-center items-center sm:p-0">
        <div x-show="open"
             x-transition:enter="ease-out duration-300"
             x-transition:enter-start="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
             x-transition:enter-end="opacity-100 translate-y-0 sm:scale-100"
             x-transition:leave="ease-in duration-200"
             x-transition:leave-start="opacity-100 translate-y-0 sm:scale-100"
             x-transition:leave-end="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
             x-description="Modal panel, show/hide based on modal state."
             class="relative transform overflow-hidden rounded-lg border-t-2 border-orange-600 bg-white dark:bg-slate-800 text-left shadow-xl transition-all my-8 w-full max-w-lg"
             @click.away="open = false">
          <div class="bg-white dark:bg-slate-800 px-4 pb-4 pt-5 sm:p-6 sm:pb-4">
            <div class="sm:flex sm:flex-col sm:items-start">
              <div class="sm:flex sm:flex-row items-center w-full">
                <div class="mt-3 w-full text-center sm:ml-4 sm:mt-0 sm:text-left text-gray-900 dark:text-white">
                  <h3 class="text-lg font-semibold leading-6"
                      id="modal-title">
                      <span x-text="server_name"></span> blacklist report
                  </h3>
                  <hr class="border-slate-200 dark:border-slate-700 my-3">
                  <div class="text-base">
                   <ul>
                    <template x-for="bl in bl_data">
                      <li>
                        <span x-text="bl"></span>
                      </li>
                    </template>
                   </ul>
                  </div>
                </div>
              </div>  
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>


<div class="my-4 grid lg:grid-cols-3 gap-4">
  @foreach($reports as $report)
    <div class="justify-between h-fit border-s-2 border-indigo-400 flex-col bg-white dark:bg-slate-900  rounded-lg drop-shadow-md p-4 hover:shadow-lg hover:transition-all animate-slide-up-fade-in">
      <div class="text-center text-lg font-semibold">
        {{ $report->server->name }}
      </div>
      <div class="card-body">
        <table id="report_{{ $report->server->id }}" class="table-auto w-full report">
          <thead>
            <tr>
              <th class="border-b dark:border-slate-600 font-medium p-1 text-slate-900 dark:text-slate-200">Status</th>
              <th class="border-b dark:border-slate-600 font-medium p-1 text-slate-900 dark:text-slate-200">Timestamp</th>
            </tr>
          </thead>
          <tbody>
            @foreach($report->blacklist_logs as $log)
              <tr>
                <td class="border-b border-slate-200 dark:border-slate-600 p-1 text-sm text-center">@if($log->blacklisted) <button x-on:click="open = true; server_name = '{{ $report->server->name }}'; bl_data = JSON.parse($el.dataset.rbl);" class="py-1 px-2 text-sm font-medium text-red-900 bg-white border rounded-lg border-gray-200 hover:bg-gray-100 dark:bg-gray-800 dark:border-gray-700 dark:text-red-400 dark:hover:bg-gray-700 btnRbl" data-rbl="{{ $log->bls_result }}">Listed</button> in {{ $log->rblCount() }} RBLs out of {{ $rbls_count }} @else <span class="text-green-600 dark:text-green-500">Clean</span> @endif </td>
                <td class="border-b border-slate-200 dark:border-slate-600 p-1 text-sm text-center">{{ $log->check_timestamp }}</td>
              </tr>
            @endforeach
          </tbody>
        </table>
      </div>
    </div>
  @endforeach
  @foreach($additional_reports as $name => $report)
    <div class="justify-between h-fit border-s-2 border-indigo-400 flex-col bg-white dark:bg-slate-900  rounded-lg drop-shadow-md p-4 hover:shadow-lg hover:transition-all animate-slide-up-fade-in">
      <div class="text-center text-lg font-semibold">
        {{ $name }}
      </div>
      <div class="card-body">
        <table id="report_{{ $name }}" class="table-auto w-full report">
          <thead>
            <tr>
              <th class="border-b dark:border-slate-600 font-medium p-1 text-slate-900 dark:text-slate-200">Status</th>
              <th class="border-b dark:border-slate-600 font-medium p-1 text-slate-900 dark:text-slate-200">Timestamp</th>
            </tr>
          </thead>
          <tbody>
            @foreach($report as $log)
              <tr>
                <td class="border-b border-slate-200 dark:border-slate-600 p-1 text-sm text-center">@if($log->blacklisted) <button x-on:click="open = true; server_name = '{{ $name }}';bl_data = JSON.parse($el.dataset.rbl);;" class="py-1 px-2 text-sm font-medium text-red-900 bg-white border rounded-lg border-gray-200 hover:bg-gray-100 dark:bg-gray-800 dark:border-gray-700 dark:text-red-400 dark:hover:bg-gray-700 btnRbl" data-rbl="{{ $log->bls_result }}">Listed</button> in {{ $log->rblCount() }} RBLs out of {{ $rbls_count }} @else <span class="text-green-600 dark:text-green-500">Clean</span> @endif </td>
                <td class="border-b border-slate-200 dark:border-slate-600 p-1 text-sm text-center">{{ $log->check_timestamp }}</td>
              </tr>
            @endforeach
          </tbody>
        </table>
      </div>
    </div>
  @endforeach
</div>
</div>

<script>
  const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
  document.addEventListener('DOMContentLoaded', function () {
    document.getElementById('menu_tools').classList.remove('text-gray-500');
    document.getElementById('menu_tools').classList.remove('hover:bg-gray-700');
    document.getElementById('menu_tools').classList.remove('hover:bg-opacity-25');
    document.getElementById('menu_tools').classList.remove('hover:text-gray-100');
    document.getElementById('menu_tools').classList.add('text-gray-100');
    document.getElementById('menu_tools').classList.add('bg-opacity-25');
    document.getElementById('menu_tools').classList.add('bg-gray-700');
    document.getElementById('menu_tools_backlist').classList.remove('text-gray-500');
    document.getElementById('menu_tools_backlist').classList.remove('hover:bg-gray-700');
    document.getElementById('menu_tools_backlist').classList.remove('hover:bg-opacity-25');
    document.getElementById('menu_tools_backlist').classList.remove('hover:text-gray-100');
    document.getElementById('menu_tools_backlist').classList.add('text-gray-100');
    document.getElementById('menu_tools_backlist').classList.add('bg-opacity-25');
    document.getElementById('menu_tools_backlist').classList.add('bg-gray-700');
    document.getElementById('menu_tools_backlist').classList.add('border-e-2');
    document.getElementById('menu_tools_backlist').classList.add('border-indigo-400');
    window.dispatchEvent(new CustomEvent('open-tools-menu'));
    var tables = document.getElementsByClassName('report');
    for (let table of tables)
    {
      new DataTable(`#${table.id}`,
      {
        perPage: 5,
        perPageSelect: [5, 30, 100, 500, ["All", 0]],
        columns: [
          {
            select: 1,
            type: "date",
            format: "MYSQL",
            sort: "desc"
          }
        ]
      });   
    }

   

  });

</script>

@endsection
