@extends('layouts.app')
@section('title') Logs @endsection
@section('content')
<div x-data="{ open: false, zone: '' }">
@include('layouts.dns-check')

<div class="flex gap-3 flex-row max-lg:flex-col my-4 animate-slide-up-fade-in">
  <div class="flex-1 gap-0 justify-between h-fit border-l-2 border-indigo-400 flex-col bg-white dark:bg-slate-900  rounded-md drop-shadow-md p-4 hover:shadow-lg hover:transition-all text-center">
    <input x-ref="search_term" type="text" class="bg-gray-50 border-s border-y border-gray-300 text-gray-900 text-sm rounded-s-lg p-2 mt-2 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white"
      placeholder="zone.tld" x-on:keyup.enter="load_logs($refs.search_term.value)"><button x-on:click="load_logs($refs.search_term.value)" class="inline-flex items-center px-4 py-2 text-sm font-medium text-gray-900 bg-white border-y border-e border-gray-300 rounded-e-lg hover:bg-gray-100 dark:bg-gray-800 dark:border-gray-600 dark:text-white dark:hover:text-white dark:hover:bg-gray-700">
      Search
    </button>
  </div>
</div>
<div class="flex gap-3 flex-row max-lg:flex-col my-4 animate-slide-up-fade-in">
  <div class="flex-1 justify-between h-fit border-l-2 border-indigo-400 flex-col bg-white dark:bg-slate-900  rounded-md drop-shadow-md p-4 hover:shadow-lg hover:transition-all">
    <div class="overflow-x-auto">
      <table id="logs_table"
         class="border-collapse table-auto w-full h-full text-sm">
        <thead>
          <tr>
            <th class="">Zone</th>
            <th class="">DNS</th>
            <th class="">Action</th>
            <th class="">Server</th>
            <th class="">Time</th>
          </tr>
        </thead>
        <tbody>
        </tbody>
      </table>
    </div>
  </div>
</div>
</div>


<script>
  const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
  document.addEventListener('DOMContentLoaded', function () {
    document.getElementById('menu_logs').classList.remove('text-gray-500');
    document.getElementById('menu_logs').classList.remove('hover:bg-gray-700');
    document.getElementById('menu_logs').classList.remove('hover:bg-opacity-25');
    document.getElementById('menu_logs').classList.remove('hover:text-gray-100');
    document.getElementById('menu_logs').classList.add('text-gray-100');
    document.getElementById('menu_logs').classList.add('bg-opacity-25');
    document.getElementById('menu_logs').classList.add('bg-gray-700');
    document.getElementById('menu_zones_logs').classList.remove('text-gray-500');
    document.getElementById('menu_zones_logs').classList.remove('hover:bg-gray-700');
    document.getElementById('menu_zones_logs').classList.remove('hover:bg-opacity-25');
    document.getElementById('menu_zones_logs').classList.remove('hover:text-gray-100');
    document.getElementById('menu_zones_logs').classList.add('text-gray-100');
    document.getElementById('menu_zones_logs').classList.add('bg-opacity-25');
    document.getElementById('menu_zones_logs').classList.add('bg-gray-700');
    document.getElementById('menu_zones_logs').classList.add('border-e-2');
    document.getElementById('menu_zones_logs').classList.add('border-indigo-400');

    window.dispatchEvent(new CustomEvent('open-logs-menu'));

    logs_table = new DataTable("#logs_table",
      {
        perPage: 100,
        perPageSelect: [100, 200, 500, ["All", 0]],
        rowRender: (row, tr, _index) => {
          tr.attributes.class = 'border-y border-slate-200 dark:border-slate-600 hover:bg-slate-200 dark:hover:bg-slate-700';
          if (tr.childNodes) {
            tr.childNodes.forEach(td => {
              td.attributes.class = "p-1 text-center";
            });
          }
        },
        labels: {
          placeholder: "Filter data..."
        },
        data: {
          headings: [
            {
              text: 'Zone',
              data: 'zone'
            },
            {
              text: 'DNS',
              data: 'dns_zone'
            },
            {
              text: 'Action',
              data: 'action',
            },
            {
              text: 'Server',
              data: 'server_name'
            },
            {
              text: 'Timestamp',
              data: 'timestamp'
            }
          ],
        },
        columns:
        [
          {
            select: 0,
            headerClass: 'font-medium p-3',
            type: 'string',
            data: 'zone'
          },
          {
            select: 1,
            headerClass: 'font-medium p-3',
            type: 'string',
            data: 'dns_zone',
            render: (data) => {
              return `<button x-on:click="open=true;zone='${data}';document.getElementById('dig_results').classList.add('hidden')" class="px-2 py-1 text-xs text-gray-900 bg-white border border-gray-200 rounded-md hover:bg-gray-100 dark:bg-gray-800 dark:border-gray-700 dark:text-white dark:hover:text-white dark:hover:bg-gray-700">check DNS</button>`;
            }
          },
          {
            select: 2,
            headerClass: 'font-medium p-3',
            type: 'string',
            data: 'action',
            render: (data) => {
              if (data === 'exclude' || data === 'delete')
                return `<span class="px-2 bg-orange-200 shadow-md dark:bg-orange-700 dark:text-white rounded-md">${data}</span>`;
              else if (data === 'remove exclude' || data === 'insert')
              return `<span class="px-2 bg-green-200 dark:bg-green-700 shadow-md dark:text-white rounded-md">${data}</span>`;
            }
          },
          {
            select: 3,
            headerClass: 'font-medium p-3',
            type: 'string',
            data: 'server_name'
          },
          {
            select: 4,
            headerClass: 'font-medium p-3',
            type: 'date',
            format: 'YYYY-MM-DD HH:mm:ss',
            data: 'timestamp'
          },
        ]
    });
    load_logs("");

  });
  @include('layouts.dns-check-js')

  function load_logs(query)
  {
    fetch('/logs/query', {
      method: 'POST',
      headers: {
        'X-CSRF-TOKEN': csrfToken,
        'Content-Type': 'application/json'
      },
      body: JSON.stringify({ query: query })
    })
      .then(response => response.json())
      .then(response => {
        if( response instanceof Array )
        {
          logs_table_data = [];
          logs_table.data.data = [];
          logs_table.update();
          response.forEach( (log) => {
            const log_record = { zone: log.zone, dns_zone: log.zone, server_name: log.server_name, timestamp: log.timestamp, action: log.action};
            logs_table_data.push(log_record);
          });
          logs_table.insert(logs_table_data);
        }
      })
      .catch(error => {
        console.error('Error:', error);
      });
  }



</script>
@endsection
